/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.provider.area;

import java.io.Serializable;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GrabAreaCodeTool {
    private static final Logger logger = LoggerFactory.getLogger(GrabAreaCodeTool.class);
    private static final int CODE_LEN = 6;
    private static final int BLOCK_LEN = 2;
    private final Map<String, AreaNode> allNodes;

    public GrabAreaCodeTool(String url) {
        this.allNodes = this.analyzeUrl(url);
    }

    public List<AreaNode> buildTree() {
        return this.buildTree(false);
    }

    public List<AreaNode> buildTree(boolean forceLevel) {
        if (this.allNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AreaNode> rootNodes = new ArrayList<AreaNode>();
        for (AreaNode value : new ArrayList<AreaNode>(this.allNodes.values())) {
            if (value.level == 1) {
                rootNodes.add(value);
                continue;
            }
            AreaNode parent = this.findRealParentNode(value, forceLevel);
            if (parent == null) continue;
            parent.children.add(value);
            value.actualParentCode = parent.code;
        }
        return rootNodes;
    }

    private AreaNode findRealParentNode(AreaNode value, boolean createOnNotExist) {
        AreaNode parent = this.findParentNode(value);
        if (parent == null) {
            return null;
        }
        if (!createOnNotExist || parent.code.equals(value.parentCode)) {
            return parent;
        }
        AreaNode newParentNode = null;
        String cityCodeT = value.code.substring(2, 4);
        newParentNode = cityCodeT.equals("90") ? new AreaNode(value.parentCode, "\u76f4\u8f96\u53bf") : new AreaNode(value.parentCode, parent.name.replace("\u5e02", ""));
        newParentNode.virtual = true;
        parent.children.add(newParentNode);
        this.allNodes.put(newParentNode.code, newParentNode);
        return newParentNode;
    }

    private AreaNode findParentNode(AreaNode value) {
        String codeDefault = "0".repeat(6);
        Object parentCode = value.parentCode;
        int level = value.level - 1;
        AreaNode parent;
        while ((parent = this.allNodes.get(parentCode)) == null) {
            if (--level == 0) {
                return null;
            }
            int index = level * 2;
            parentCode = ((String)parentCode).substring(0, index) + codeDefault.substring(index);
        }
        return parent;
    }

    private Map<String, AreaNode> analyzeUrl(String url) {
        SSLSocketFactory originalSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        SSLContext sslContext = GrabAreaCodeTool.buildSSLContext();
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        try {
            logger.info("\u5f00\u59cb\u6293\u53d6\u884c\u653f\u533a\u57df\u6570\u636e\uff0c\u6570\u636e\u5730\u5740\uff1a{}", (Object)url);
            Document doc = Jsoup.connect((String)url).timeout(30000).get();
            Element table = doc.select("table").first();
            Assert.notNull((Object)table, (String)"\u83b7\u53d6\u884c\u653f\u533a\u6570\u636e\u5931\u8d25");
            Elements rows = table.select("tr");
            LinkedHashMap<String, AreaNode> allNodes = new LinkedHashMap<String, AreaNode>();
            AreaNode areNode = null;
            for (Element row : rows) {
                Elements cols = row.select("td");
                int startIndex = cols.size() >= 3 ? 1 : 0;
                String code = ((Element)cols.get(startIndex)).text().trim();
                String name = ((Element)cols.get(startIndex + 1)).text().trim();
                if (code.isEmpty() || name.isEmpty() || !code.matches("\\d{6}")) continue;
                areNode = new AreaNode(code, name);
                allNodes.put(areNode.code, areNode);
            }
            logger.info("\u89e3\u6790\u5b8c\u6210\uff0c\u5171\u83b7\u53d6 {} \u4e2a\u6709\u6548\u884c\u653f\u533a\u5212", (Object)allNodes.size());
            LinkedHashMap<String, AreaNode> linkedHashMap = allNodes;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u884c\u653f\u533a\u6570\u636e\u5f02\u5e38", e);
        }
        finally {
            if (originalSocketFactory != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(originalSocketFactory);
            }
            if (hostnameVerifier != null) {
                HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            }
        }
    }

    private static SSLContext buildSSLContext() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u5efaSslContext\u5f02\u5e38", e);
        }
        return sslContext;
    }

    public static class AreaNode
    implements Serializable {
        private static final long serialVersionUID = 2653467613223198117L;
        private final String code;
        private final String name;
        private final int level;
        private final String parentCode;
        private String actualParentCode;
        private boolean virtual;
        private final List<AreaNode> children = new ArrayList<AreaNode>();

        public AreaNode(String nodeCode, String nodeName) {
            this.code = nodeCode;
            this.name = nodeName.replace("*", "");
            this.level = this.determineLevel(nodeCode);
            this.parentCode = this.determineParentCode(nodeCode, this.level);
        }

        public String toString() {
            String label = this.getDirectLabel();
            return this.name + "(" + this.code + ")" + (String)(label == null ? "" : " " + label);
        }

        public String getDirectLabel() {
            if (this.level == 1) {
                if (!this.children.isEmpty() && (this.children.get((int)0).level == 3 || this.children.get((int)0).virtual)) {
                    return "\u76f4\u8f96\u5e02";
                }
                return null;
            }
            if (this.level == 3) {
                if (this.code.startsWith("90", 2)) {
                    return "\u7701\u76f4\u8f96\u53bf";
                }
                return null;
            }
            return null;
        }

        public void preview(String indent, StringBuilder content) {
            content.append(indent + String.valueOf(this) + " (\u5c42\u7ea7: " + this.level + ") \n");
            if (this.children.isEmpty()) {
                return;
            }
            this.children.sort(Comparator.comparing(node -> node.code));
            for (AreaNode child : this.children) {
                child.preview(indent + "  ", content);
            }
        }

        private String determineParentCode(String code, int level) {
            if (level == 1) {
                return null;
            }
            String codeDefault = "0".repeat(6);
            int index = (level - 1) * 2;
            return code.substring(0, index) + codeDefault.substring(index);
        }

        private int determineLevel(String code) {
            int blocks = 3;
            String codeDefault = "0".repeat(6);
            for (int i = 1; i <= blocks; ++i) {
                int index = i * 2;
                String tempCode = code.substring(0, index) + codeDefault.substring(index);
                if (!tempCode.equals(code)) continue;
                return i;
            }
            return blocks;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public String getParentCode() {
            return this.parentCode;
        }

        public String getActualParentCode() {
            return this.actualParentCode;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public List<AreaNode> getChildren() {
            return this.children;
        }
    }
}

