//package com.elitescloud.cloudt.platform.controller.api;
//
//import com.alibaba.excel.EasyExcel;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//
//import com.elitescloud.cloudt.platform.model.entity.SysPlatformSqlExecuteDO;
//import com.elitescloud.cloudt.platform.model.params.sql.SysPlatformSqlExecuteParam;
//import com.elitescloud.cloudt.platform.model.vo.SqlExecuteDataVo;
//import com.elitescloud.cloudt.platform.service.SysPlatformSqlExecuteService;
//
//import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import lombok.extern.slf4j.Slf4j;
//
//import org.springframework.web.bind.annotation.*;
//import org.springframework.web.multipart.MultipartFile;
//
//import javax.validation.Valid;
//
//import java.util.List;
//
//
///**
// * @author : chen.niu
// * @description : 通用sql执行
// * @date : 2023/10/25 10:44
// */
//
//@Slf4j
//@RestController
//@Api(value = "平台通用sql执行", tags = {"平台通用sql执行"})
//@RequestMapping("/sys/platform/sqlexecute")
//public class SysPlatformSqlExecuteController {
//
//
//    private final SysPlatformSqlExecuteService sqlExecuteService;
//
//    public SysPlatformSqlExecuteController(
//            SysPlatformSqlExecuteService sqlExecuteService) {
//
//        this.sqlExecuteService = sqlExecuteService;
//    }
//
//
//    /**
//     * 分页查询记录
//     *
//     * @param queryVO 查询参数
//     * @return 分页数据
//     */
//    @ApiOperation(value = "分页查询记录")
//    @ApiOperationSupport(order = 1)
//    @PostMapping(value = "/page")
//    public ApiResult<PagingVO<SysPlatformSqlExecuteDO>> page(@RequestBody SysPlatformSqlExecuteParam queryVO) {
//
//        return sqlExecuteService.page(queryVO);
//
//    }
//
//    @PostMapping("/add")
//    @ApiOperation(value = "添加", notes = "")
//    public ApiResult<Long> add(@RequestBody @Valid SysPlatformSqlExecuteParam addParam) {
//        return sqlExecuteService.add(addParam);
//    }
//
//    //
//    @PutMapping("/update/{id}")
//    @ApiOperation(value = "更新")
//    public ApiResult<Boolean> update(@PathVariable Long id, @RequestBody SysPlatformSqlExecuteParam updateParam) {
//        return sqlExecuteService.update(id, updateParam);
//    }
//
//    @GetMapping("/getById/{id}")
//    @ApiOperation(value = "id查询")
//    public ApiResult<SysPlatformSqlExecuteDO> findById(@PathVariable Long id) {
//        return sqlExecuteService.findById(id);
//    }
//
//    @PutMapping("/delete")
//    @ApiOperation(value = "删除", notes = "删除")
//    public ApiResult<Boolean> deleteByIds(@RequestBody List<Long> ids) {
//        return sqlExecuteService.deleteByIds(ids);
//    }
//
//    @PostMapping("/execute/{id}")
//    public ApiResult<SysPlatformSqlExecuteDO> executeQuery(@PathVariable Long id) {
//        return sqlExecuteService.executeQuery(id);
//    }
//
//
//    @PostMapping("/import")
//    public ApiResult<String> importData(@RequestParam("file") MultipartFile file) {
//        try {
//            List<SqlExecuteDataVo> dataList = EasyExcel.read(file.getInputStream()).headRowNumber(2)
//                    .head(SqlExecuteDataVo.class)
//                    .sheet(0).doReadSync();
//            for (SqlExecuteDataVo data : dataList) {
//                if (data.getSqlCode() == null) {
//                    throw new RuntimeException("编码为空错误：" + data.getSqlName());
//                }
//            }
//            return sqlExecuteService.importData(dataList);
//        } catch (Exception e) {
//            e.printStackTrace();
//            return ApiResult.fail("excel读取失败异常：" + e.getMessage());
//        }
//    }
//
//
//}
