package com.elitescloud.cloudt.platform.model.constant;

import com.elitescloud.cloudt.system.vo.SysUdcVO;

public enum SysPlatformSettingGroupEnum {

    USER_SECURITY_GROUP("SYS_PLATFORM", "APP_TYPE", "参数分组", "用户安全",1),
    PLATFORM_SETTING_GROUP("SYS_PLATFORM", "APP_TYPE", "参数分组", "平台设置",2),
    ;



    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    SysPlatformSettingGroupEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public String getDescription() {
        return description;
    }
}
