package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.lang.UUID;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.SysPlatformDataSourceConvert;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformDatabaseSourceDO;
import com.elitescloud.cloudt.platform.service.SysPlatformDatabaseSourceService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformDatabaseSourceRepo;
import com.elitescloud.cloudt.system.datasource.*;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/25 13:53
 */
@Service
public class SysPlatformDatabaseSourceServiceImpl implements SysPlatformDatabaseSourceService {
    String mysqlDriver = "com.mysql.cj.jdbc.Driver";
    private final SysPlatformDatabaseSourceRepo sysPlatformDatabaseSourceRepo;

    public SysPlatformDatabaseSourceServiceImpl(SysPlatformDatabaseSourceRepo sysPlatformDatabaseSourceRepo) {
        this.sysPlatformDatabaseSourceRepo = sysPlatformDatabaseSourceRepo;
    }


    @Override
    public ApiResult<List<SysPlatformDatabaseSourceVO>> query(SysPlatformDatabaseSourceQueryParam param) {
        var predicate = sysPlatformDatabaseSourceRepo.getPredicate(param);
        List<SysPlatformDatabaseSourceVO> sysPlatformDatabaseSourceVOS = new ArrayList<>();
        sysPlatformDatabaseSourceRepo.findAll(predicate)
                .iterator().forEachRemaining(boFieldDefinitionDo -> {
                    SysPlatformDatabaseSourceVO vo = SysPlatformDataSourceConvert.INSTANCE.DoToVo(boFieldDefinitionDo);
                    sysPlatformDatabaseSourceVOS.add(vo);
                });
        return ApiResult.ok(sysPlatformDatabaseSourceVOS);
    }

    @Override
    public ApiResult<String> queryPasswordById(Long id) {
        var dsDo = sysPlatformDatabaseSourceRepo.findById(id).orElse(null);
        if (StringUtils.isEmpty(dsDo)) {
            return ApiResult.fail("数据源不存在");
        }
        return ApiResult.ok(dsDo.getDbsPassword());
    }

    @Override
    public ApiResult<SysPlatformDatabaseSourceVO> getById(Long id) {
        SysPlatformDatabaseSourceDO dsDo = sysPlatformDatabaseSourceRepo.findById(id).orElse(null);
        if (dsDo == null) {
            return ApiResult.fail("数据源不存在");
        }
        SysPlatformDatabaseSourceVO vo = SysPlatformDataSourceConvert.INSTANCE.DoToVo(dsDo);
//        BeanUtils.copyProperties(dsDo, vo);
        return ApiResult.ok(vo);
    }

    @Override
    public ApiResult<SysPlatformDatabaseSourceVO> getByDbsCode(String dbsCode) {
        SysPlatformDatabaseSourceQueryParam param = new SysPlatformDatabaseSourceQueryParam();
        param.setDbsCode(dbsCode);
        var predicate = sysPlatformDatabaseSourceRepo.getPredicate(param);
        var dbDo = sysPlatformDatabaseSourceRepo.findOne(predicate).orElse(null);
        if (dbDo != null) {
//            BeanUtils.copyProperties(dbDo, vo);
            SysPlatformDatabaseSourceVO vo = SysPlatformDataSourceConvert.INSTANCE.DoToVo(dbDo);
            return ApiResult.ok(vo);
        } else {
            return ApiResult.fail("数据源不存在");
        }

    }

    @Override
    public ApiResult<Long> save(SysPlatformDatabaseSourceSaveParam saveVO) {
        //如果没有填写编码 随机生成一个编码。
        if (saveVO.getDbsCode() == null || saveVO.getDbsCode().isBlank()) {
            saveVO.setDbsCode(UUID.randomUUID().toString());
        } else {
            SysPlatformDatabaseSourceDO dbDo = sysPlatformDatabaseSourceRepo.findByDbsCode(saveVO.getDbsCode());
            if (dbDo != null) {
                return ApiResult.fail("数据源编码已存在");
            }
        }
        SysPlatformDatabaseSourceDO dbDo = SysPlatformDataSourceConvert.INSTANCE.saveVOToDo(saveVO);
        if (dbDo.getDbsDriverClass() == null) {
            dbDo.setDbsDriverClass(mysqlDriver);
        }
        sysPlatformDatabaseSourceRepo.save(dbDo);
        return ApiResult.ok(dbDo.getId());
    }

    @Override
    public ApiResult<Long> update(Long id, SysPlatformDatabaseSourceUpParam saveVO) {
        SysPlatformDatabaseSourceDO dbDo = sysPlatformDatabaseSourceRepo.findById(id).orElse(null);
        if (dbDo != null) {
            if (saveVO.getDbsPassword() == null || saveVO.getDbsPassword().isBlank()) {
                saveVO.setDbsPassword(dbDo.getDbsPassword());
            }
            SysPlatformDataSourceConvert.INSTANCE.saveVOToDo(saveVO, dbDo);
//          BeanUtils.copyProperties(saveVO, dbDo);
            if (dbDo.getDbsDriverClass() == null) {
                dbDo.setDbsDriverClass(mysqlDriver);
            }
            sysPlatformDatabaseSourceRepo.save(dbDo);
            return ApiResult.ok(dbDo.getId());
        } else {
            return ApiResult.fail("数据源不存在");
        }
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        sysPlatformDatabaseSourceRepo.deleteById(id);
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<String> testConnection(DatabaseConfigDTO config) {
        try {
            DataSource dataSource = createDataSource(config);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            jdbcTemplate.execute("SELECT 1");
            return ApiResult.ok("测试成功");
        } catch (Exception e) {
            return ApiResult.fail("链接异常:" + e.getMessage());
        }
    }
    @Override
    public ApiResult<String> testConnectionById(Long dbDataSourceId) {
        try {
            SysPlatformDatabaseSourceDO dsDo
                    = sysPlatformDatabaseSourceRepo.findById(dbDataSourceId).orElse(null);

            if(dsDo!=null){
                 DatabaseConfigDTO config=new DatabaseConfigDTO();
                config.setUrl(dsDo.getDbsUrl());
                config.setUsername(dsDo.getDbsUsername());
                config.setPassword(dsDo.getDbsPassword());
                config.setDriverClass(dsDo.getDbsDriverClass());
                DataSource dataSource = createDataSource(config);
                JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
                jdbcTemplate.execute("SELECT 1");
                return ApiResult.ok("测试成功");
            }else{
                return ApiResult.fail("没有找到数据源:"+dbDataSourceId);
            }

        } catch (Exception e) {
            return ApiResult.fail("链接异常:" + e.getMessage());
        }
    }

    private DataSource createDataSource(DatabaseConfigDTO config) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(config.getUrl());
        dataSource.setUsername(config.getUsername());
        dataSource.setPassword(config.getPassword());
        if (config.getDriverClass() == null) {
            dataSource.setDriverClassName(mysqlDriver);
        } else {
            dataSource.setDriverClassName(config.getDriverClass());
        }
        return dataSource;
    }
}
