package com.elitescloud.cloudt.platform.model.constant;


import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 管理员类型
 **/
public enum PlatformAdminTypeEnum {
    SYS_ADMIN("SYS_PLATFORM", "PlatformAdminType", "管理员类型", "系统管理员", 1),
    TENANT_ADMIN("SYS_PLATFORM", "PlatformAdminType", "管理员类型", "租户管理员", 2),
    TENANT_ORG_ADMIN("SYS_PLATFORM", "PlatformAdminType", "管理员类型", "租户组织管理员", 3);


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformAdminTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }

    private static final Map<String, PlatformAdminTypeEnum> ALL = Arrays.stream(PlatformAdminTypeEnum.values())
            .collect(Collectors.toMap(PlatformAdminTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析管理员类型
     *
     * @param value 待解析字符串
     * @return
     */
    public static PlatformAdminTypeEnum parse(String value) {
        if (CharSequenceUtil.isBlank(value)) {
            return null;
        }
        return ALL.get(value);
    }
}
