package com.elitescloud.cloudt.platform.service.repo;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformUdcValueDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcValueParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueMngVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;


/**
 * @Description: 平台应用udc
 * @author: lucan.liu
 * @date: 2023.11.13
 **/

@Repository
public class SysPlatformUdcValueMngRepo extends BaseRepoProc<SysPlatformUdcValueDO> {

    private static final QSysPlatformUdcDO udcDO = QSysPlatformUdcDO.sysPlatformUdcDO;
    private static final QSysPlatformUdcValueDO valueDO = QSysPlatformUdcValueDO.sysPlatformUdcValueDO;

    protected SysPlatformUdcValueMngRepo() {
        super(valueDO);
    }


    public SysPlatformUdcValueMngVO queryUdcCode(QueryUdcParam param) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(valueDO.appCode,param.getAppCode())
                .andLike(valueDO.udcValueName, param.getUdcValueName())
                .andLike(valueDO.udcValueCode, param.getUdcValueCode())
                .build();
        JPAQuery<SysPlatformUdcValueMngVO> select = jpaQueryFactory.select(Projections.bean(SysPlatformUdcValueMngVO.class, valueDO.udcCode))
                .from(valueDO)
                .where(predicate);
        return select.fetchOne();
    }

    public List<SysPlatformUdcValueMngVO> queryUdcValueList(HashMap<String,Object> param) {
        return jpaQueryFactory.select(Projections.bean(SysPlatformUdcValueMngVO.class,
                valueDO.id,
                valueDO.udcCode,
                valueDO.udcValueName,
                valueDO.udcValueCode,
                valueDO.appCode,
                valueDO.valueAliasName,
                valueDO.udcOrder,
                valueDO.allowDefault,
                valueDO.allowStart,
                valueDO.udcValueDescribe,
                valueDO.parentUdcValueCode,
                valueDO.tenantId,
                valueDO.remark,
                valueDO.createTime,
                valueDO.creator,
                valueDO.updater,
                valueDO.modifyTime
                ))
                .from(valueDO)
                .where(valueDO.appCode.eq(param.get("appCode").toString()).and(valueDO.udcCode.eq(param.get("udcCode").toString())))
                .fetch();
    }

    public PagingVO<SysPlatformUdcValueMngVO> getUdcValuePage(QueryUdcValueParam param) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(valueDO.appCode,param.getAppCode())
                .andLike(valueDO.udcCode, param.getUdcCode())
                .andLike(udcDO.udcName,param.getUdcName())
                .andEq(valueDO.allowDefault,param.getAllowDefault())
                .andEq(valueDO.allowStart,param.getAllowStart())
                .andLike(valueDO.udcValueCode, param.getUdcValueCode())
                .andLike(valueDO.udcValueName,param.getUdcValueName())
                .build();
        JPAQuery<SysPlatformUdcValueMngVO> select = jpaQueryFactory.select(Projections.bean(SysPlatformUdcValueMngVO.class,
                        valueDO.id,
                        valueDO.appCode,
                        valueDO.udcCode,
                        valueDO.udcValueCode,
                        valueDO.udcValueName,
                        udcDO.udcName,
                        valueDO.allowStart,
                        valueDO.allowDefault,
                        valueDO.udcOrder,
                        udcDO.parentUdcCode,
                        valueDO.deleteFlag,
                        valueDO.tenantId,
                        valueDO.belongOrgId,
                        valueDO.tenantOrgId,
                        valueDO.createTime,
                        valueDO.updater,
                        valueDO.modifyTime,
                        valueDO.creator,
                        valueDO.remark
                ))
                .from(valueDO).leftJoin(udcDO).on(valueDO.appCode.eq(udcDO.appCode).and(valueDO.udcCode.eq(udcDO.udcCode)))
                .where(predicate)
                .groupBy(valueDO.udcValueCode,
                        valueDO.id,
                        valueDO.appCode,
                        valueDO.udcCode,
                        valueDO.udcValueCode,
                        valueDO.udcValueName,
                        udcDO.udcName,
                        valueDO.allowStart,
                        valueDO.allowDefault,
                        valueDO.udcOrder,
                        udcDO.parentUdcCode,
                        valueDO.deleteFlag,
                        valueDO.tenantId,
                        valueDO.belongOrgId,
                        valueDO.tenantOrgId,
                        valueDO.createTime,
                        valueDO.updater,
                        valueDO.modifyTime,
                        valueDO.creator,
                        valueDO.remark);
        return super.queryByPage(select, param.getPageRequest(),valueDO.createTime.desc());
    }

}

