/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.system.service.common.constant.AppAuthTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SysPlatformAppRepoProc
extends BaseRepoProc<SysPlatformAppDO> {
    private static final QSysPlatformAppDO QDO = QSysPlatformAppDO.sysPlatformAppDO;
    private static final QSysTenantAppDO QDO_TENANT_APP = QSysTenantAppDO.sysTenantAppDO;

    public SysPlatformAppRepoProc() {
        super((EntityPathBase)QDO);
    }

    public List<SysPlatformAppDO> listByAppCodes(Collection<String> appCodes) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)SysPlatformAppRepoProc.QDO.appCode, appCodes).build();
        return super.getList(predicate, new OrderSpecifier[]{this.defaultOrder()});
    }

    public List<CodeNameParam> allEnabled() {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)SysPlatformAppRepoProc.QDO.appState, (Object)true).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CodeNameParam.class, (Expression[])new Expression[]{SysPlatformAppRepoProc.QDO.appCode.as("code"), SysPlatformAppRepoProc.QDO.appName.as("name")})).from((EntityPath)QDO)).where(predicate)).orderBy(this.defaultOrder())).fetch();
    }

    public List<SysPlatformAppDO> allEnabled(Boolean outerApp, Boolean authed) {
        Predicate predicate = this.predicateForOuterAuthed(outerApp, authed);
        return super.getList(predicate, new OrderSpecifier[]{this.defaultOrder()});
    }

    public PagingVO<SysPlatformAppDO> pageMng(QueryAppParam param) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)SysPlatformAppRepoProc.QDO.appCode, param.getAppCode()).andLike((StringExpression)SysPlatformAppRepoProc.QDO.appName, param.getAppName()).build();
        return super.queryByPage(predicate, param.getPageRequest(), this.defaultOrder());
    }

    public PagingVO<SysPlatformAppDO> pageQuery(QueryAppParam param) {
        Predicate predicateAuth = this.predicateForOuterAuthed(param.getOuterApp(), param.getAuthed());
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)SysPlatformAppRepoProc.QDO.appCode, param.getAppCode()).andLike((StringExpression)SysPlatformAppRepoProc.QDO.appName, param.getAppName()).andEq((SimpleExpression)SysPlatformAppRepoProc.QDO.appState, (Object)true).and(predicateAuth).build();
        return super.queryByPage(predicate, param.getPageRequest(), this.defaultOrder());
    }

    public List<SysPlatformAppDO> listOuterApp(Long tenantId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)SysPlatformAppRepoProc.QDO.appState, (Object)true).andEq((SimpleExpression)SysPlatformAppRepoProc.QDO.outerApp, (Object)true).and(tenantId != null && tenantId.longValue() != TenantConstant.DEFAULT_TENANT_ID.longValue(), () -> SysPlatformAppRepoProc.QDO.appCode.in((SubQueryExpression)JPAExpressions.select((Expression)SysPlatformAppRepoProc.QDO_TENANT_APP.appCode).from(new EntityPath[]{QDO_TENANT_APP}).where(new Predicate[]{SysPlatformAppRepoProc.QDO_TENANT_APP.sysTenantId.eq((Object)tenantId)}))).build();
        return super.getList(predicate, new OrderSpecifier[]{this.defaultOrder()});
    }

    public List<SysPlatformAppDO> list(Boolean outerApp, Boolean authed) {
        Predicate predicate = this.predicateForOuterAuthed(outerApp, authed);
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where(predicate)).orderBy(this.defaultOrder())).fetch();
    }

    private Predicate predicateForOuterAuthed(Boolean outerApp, Boolean authed) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)SysPlatformAppRepoProc.QDO.appState, (Object)true).andEq(outerApp != null, (SimpleExpression)SysPlatformAppRepoProc.QDO.outerApp, (Object)outerApp).and(authed != null, () -> {
            if (authed == null) {
                return null;
            }
            if (authed.booleanValue()) {
                if (outerApp == null) {
                    return SysPlatformAppRepoProc.QDO.outerApp.eq(Boolean.valueOf(false)).or((Predicate)SysPlatformAppRepoProc.QDO.authType.eq((Object)AppAuthTypeEnum.AUTHED.name()));
                }
                return outerApp != false ? SysPlatformAppRepoProc.QDO.authType.eq((Object)AppAuthTypeEnum.AUTHED.name()) : null;
            }
            if (outerApp == null) {
                return SysPlatformAppRepoProc.QDO.outerApp.eq(Boolean.valueOf(true)).or((Predicate)SysPlatformAppRepoProc.QDO.authType.eq((Object)AppAuthTypeEnum.UNNECESSARY.name()));
            }
            if (outerApp.booleanValue()) {
                return SysPlatformAppRepoProc.QDO.authType.eq((Object)AppAuthTypeEnum.UNNECESSARY.name());
            }
            return SysPlatformAppRepoProc.QDO.outerApp.eq(Boolean.valueOf(false)).and((Predicate)SysPlatformAppRepoProc.QDO.authType.eq((Object)AppAuthTypeEnum.AUTHED.name()));
        }).build();
    }

    private OrderSpecifier<Integer> defaultOrder() {
        return SysPlatformAppRepoProc.QDO.appOrder.asc();
    }
}

