/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.security.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum RoleWhiteListEnum {
    ADMIN(true, "\u7cfb\u7edf\u7ba1\u7406\u5458"),
    TENANT_ADMIN(true, "\u79df\u6237\u7ba1\u7406\u5458");

    private final boolean enable;
    private final String name;
    private static final Map<String, RoleWhiteListEnum> ALL;

    private RoleWhiteListEnum(boolean enable, String name) {
        this.enable = enable;
        this.name = name;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getName() {
        return this.name;
    }

    public static Set<String> getAllCode() {
        return Collections.unmodifiableSet(ALL.keySet());
    }

    public static boolean exists(String roleCode) {
        if (roleCode == null) {
            return false;
        }
        return ALL.containsKey(roleCode.toUpperCase());
    }

    static {
        ALL = Arrays.stream(RoleWhiteListEnum.values()).collect(Collectors.toMap(Enum::name, t -> t, (t1, t2) -> t1));
    }
}

