/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.security.config.support.metadata;

import com.elitescloud.cloudt.security.common.RoleWhiteListEnum;
import com.elitescloud.cloudt.security.config.CustomSecurityProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CloudtRoleVoter
extends RoleVoter {
    private final Set<String> whiteRoles = Arrays.stream(RoleWhiteListEnum.values()).filter(RoleWhiteListEnum::isEnable).map(role -> super.getRolePrefix() + role.name()).collect(Collectors.toSet());

    public CloudtRoleVoter(CustomSecurityProperties customSecurityProperties) {
        if (!CollectionUtils.isEmpty(customSecurityProperties.getIgnoreRoles())) {
            Set roles = customSecurityProperties.getIgnoreRoles().stream().filter(StringUtils::hasText).map(role -> super.getRolePrefix() + role).collect(Collectors.toSet());
            this.whiteRoles.addAll(roles);
        }
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication == null) {
            return -1;
        }
        int result = 0;
        Collection<? extends GrantedAuthority> authorities = this.extractAuthorities(authentication);
        for (ConfigAttribute attribute : attributes) {
            if (attribute.getAttribute().equals(this.deniedRole())) {
                return -1;
            }
            if (!this.supports(attribute)) continue;
            result = -1;
            for (GrantedAuthority grantedAuthority : authorities) {
                if (!this.whiteRoles.contains(grantedAuthority.getAuthority()) && !attribute.getAttribute().equals(grantedAuthority.getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }

    Collection<? extends GrantedAuthority> extractAuthorities(Authentication authentication) {
        return authentication.getAuthorities();
    }

    private String deniedRole() {
        return super.getRolePrefix() + "DENIED";
    }
}

