/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.datasource;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DataSourceTypeEnum {
    MYSQL("SYS_PLATFORM", "DataSourceType", "\u6570\u636e\u5e93\u7c7b\u578b", "MYSQL", 1),
    ORACLE("SYS_PLATFORM", "DataSourceType", "\u6570\u636e\u5e93\u7c7b\u578b", "ORACLE", 2),
    SQLSERVER("SYS_PLATFORM", "DataSourceType", "\u6570\u636e\u5e93\u7c7b\u578b", "SQLSERVER", 3),
    POSTGRESQL("SYS_PLATFORM", "DataSourceType", "\u6570\u636e\u5e93\u7c7b\u578b", "POSTGRESQL", 4);

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;
    private static final Map<String, DataSourceTypeEnum> ALL;

    private DataSourceTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId(Long.valueOf(this.sortNo));
        return sysUdcVO;
    }

    public static DataSourceTypeEnum parse(String value) {
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return ALL.get(value);
    }

    static {
        ALL = Arrays.stream(DataSourceTypeEnum.values()).collect(Collectors.toMap(Enum::name, t -> t, (t1, t2) -> t1));
    }
}

