package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheUserRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "系统账号")
public class SysCacheUserRpcServiceImpl extends AbstractCacheableService implements SysCacheUserRpcService {

    @CloudtCacheMethod(name = "根据ID获取账号信息")
    @Override
    public SysUserBasicDTO getById(Long id) {
        Assert.notNull(id, "账号ID为空");

        return getRpcService().getById(id).computeData();
    }

    @CloudtCacheMethod(name = "根据登录号获取账号信息")
    @Override
    public SysUserBasicDTO getByUsername(String username) {
        Assert.notBlank(username, "账号为空");

        return getRpcService().getByUsername(username).computeData();
    }

    @CloudtCacheMethod(name = "获取账号列表")
    @Override
    public List<SysUserBasicDTO> listAll() {
        return getRpcService().queryUser(new UserQueryDTO()).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "user";
    }

    @Override
    public boolean supportTenant() {
        return true;
    }

    private UserRpcService getRpcService() {
        return getService(UserRpcService.class);
    }
}
