package com.elitescloud.cloudt.system.constant;

import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息类型
 */
public enum MsgTypeEnum {
    TEMPLATE("TEMPLATE", "模板消息", 1),
    CUSTOM("CUSTOM", "自定义消息", 2),
    ;


    private final String code;
    private final String description;
    private final int sortNo;

    MsgTypeEnum(String code, String description, int sortNo) {
        this.code = code;
        this.description = description;
        this.sortNo = sortNo;
    }

    public String getDescription() {
        return description;
    }

    public String getCode() {
        return code;
    }

    public int getSortNo() {
        return sortNo;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setUdcCode(this.code);
        sysUdcVO.setUdcName(this.description);
        sysUdcVO.setUdcVal(this.code);
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        return sysUdcVO;
    }

    public static List<SysUdcVO> getSysUdcVOList() {
        ArrayList<SysUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
