package com.elitescloud.cloudt.system.provider.msg;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysSiteMsgSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.msg.SysSiteMsgViewedDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 站内信服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/28
 */
@FeignClient(name = Application.NAME, path = SysThirdApiLogRpcService.URI)
@Validated
public interface SiteMsgRpcService {
    String URI = Application.URI_PREFIX + "/siteMsg";

    /**
     * 发送站内信
     *
     * @param saveDTO 站内信信息
     * @return 发送结果
     */
    @PostMapping(value = "/send")
    ApiResult<String> send(@RequestBody @Valid SysSiteMsgSaveDTO saveDTO);

    /**
     * 删除站内信
     *
     * @param batchId 批次ID
     * @return 删除结果
     */
    @DeleteMapping(value = "/delete")
    ApiResult<String> delete(@RequestParam(name = "batchId") @NotBlank(message = "消息批次ID为空") String batchId);

    /**
     * 查询阅读情况
     *
     * @param batchId 批次ID
     * @return 阅读情况
     */
    @GetMapping(value = "/viewed")
    ApiResult<List<SysSiteMsgViewedDTO>> queryViewedResult(@RequestParam(name = "batchId") @NotBlank(message = "消息批次ID为空") String batchId);
}
