package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.boot.model.dto.SysBusinessObjectDTO;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 业务对象.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheBusinessObjectRpcService extends CacheableService {

    /**
     * 获取所有的业务对象
     *
     * @return
     */
    List<SysBusinessObjectDTO> allBusinessObject();

    /**
     * 获取业务对象详细信息
     *
     * @param businessObjectCode
     * @return
     */
    SysBusinessObjectDTO getBusinessObjectDetail(@NotBlank String businessObjectCode);

    /**
     * 获取所有业务对象操作
     *
     * @return 业务对象操作
     */
    List<SysBusinessOperationDTO> allOperation();
}
