package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheDatabaseSourceRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceQueryParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceVO;
import com.elitescloud.cloudt.system.datasource.service.SysPlatformDatabaseSourceRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "平台数据源")
public class SysCacheDatabaseSourceRpcServiceImpl extends AbstractCacheableService implements SysCacheDatabaseSourceRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "databaseSource";
    }

    @CloudtCacheMethod(name = "获取数据源列表")
    @Override
    public List<SysPlatformDatabaseSourceVO> getAll() {
        return getService(SysPlatformDatabaseSourceRpcService.class).query(new SysPlatformDatabaseSourceQueryParam()).computeData();
    }

    @CloudtCacheMethod(name = "根据编码获取数据源信息")
    @Override
    public SysPlatformDatabaseSourceVO getByCode(String code) {
        Assert.hasText(code, "编码为空");

        return getService(SysPlatformDatabaseSourceRpcService.class).getByDbsCode(code).computeData();
    }
}
