package com.elitescloud.cloudt.system.dto.req;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 员工查询参数.
 *
 * @author Kaiser（wang shao）
 * 2022/12/20
 */
@Data
public class EmployeeQueryDTO implements Serializable {
    private static final long serialVersionUID = -5319332516791686876L;

    /**
     * 员工ID
     */
    private Set<Long> ids;

    /**
     * 登录号
     */
    private Set<String> usernames;

    /**
     * 用户ID
     */
    private Set<Long> userIds;

    /**
     * 员工编号
     */
    private Set<String> codes;

    /**
     * 电话
     */
    private Set<String> phones;

    /**
     * 邮箱
     */
    private Set<String> emails;

    /**
     * 员工类型 [UDC]cloudt-system:employeeType
     */
    private String type;

    /**
     * 职务
     */
    private String duty;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 是否在职
     */
    private Boolean enabled;

    /**
     * 姓名-姓氏
     */
    private String lastName;

    /**
     * 姓名-名字
     */
    private String firstName;

    /**
     * 员工编号或姓名
     */
    private String codeOrName;

    /**
     * 所属组织ID
     */
    private Long orgId;
    private List<Long> orgIds;
    /**
     * 所属组织编码
     */
    private String orgCode;
    private List<String> orgCodes;

    /**
     * 归属组织ID
     */
    private Long orgIdBelong;

    /**
     * 归属组织编码
     */
    private String orgCodeBelong;

    /**
     * 岗位ID
     */
    private Long positionId;
    private List<Long> positionIds;

    /**
     * 岗位编码
     */
    private String positionCode;
    private List<String> positionCodes;
}
