package com.elitescloud.cloudt.system.dto.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 角色组.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/24
 */
@Data
@ApiModel(description = "角色组")
public class RoleGroupPageRespVO implements Serializable {
    private static final long serialVersionUID = -7709240127331148247L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "分组编码", position = 2)
    private String groupCode;

    @ApiModelProperty(value = "分组名称", position = 3)
    @NotBlank(message = "分组名称不能为空")
    private String groupName;

    @ApiModelProperty(value = "启用状态", position = 4)
    private Boolean enabled;

    @ApiModelProperty(value = "角色数量", position = 5)
    private Long roleNum;

    @ApiModelProperty(value = "描述", position = 11)
    private String description;

    @ApiModelProperty(value = "创建时间", position = 12)
    private LocalDateTime createTime;
}
