package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 员工.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheEmployeeRpcService extends CacheableService {

    /**
     * 根据员工ID获取
     *
     * @param id
     * @return
     */
    SysEmployeeBasicDTO getById(@NotNull Long id);

    /**
     * 根据员工编码获取
     *
     * @param code
     * @return
     */
    SysEmployeeBasicDTO getByCode(@NotBlank String code);

    /**
     * 根据账号ID获取
     *
     * @param userId
     * @return
     */
    SysEmployeeBasicDTO getByUserId(@NotNull Long userId);

    /**
     * 根据员工登录号获取
     *
     * @param username
     * @return
     */
    SysEmployeeBasicDTO getByUsername(@NotBlank String username);

    /**
     * 获取所有
     *
     * @return
     */
    List<SysEmployeeBasicDTO> listAll();
}
