package com.elitescloud.cloudt.system.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消息类型枚举
 * **/
public enum MsgSendTypeEnum {
    SYS_INTERIOR( "SYS_INTERIOR", "系统站内",1),
    EMAIL("EMAIL", "邮件",2),
    MOBILE_SMS("MOBILE_SMS", "短信",3),
    MINI_PROGRAM("MINI_PROGRAM", "小程序",4),
    OFFICIAL_ACCOUNT("OFFICIAL_ACCOUNT", "公众号",5),
    APP("APP", "原生APP",6),
    WX_BOOT("WX_BOOT", "企微机器人",7),
    ;


    private final String code;
    private final String description;
    private final int sortNo;

    MsgSendTypeEnum(String code, String description, int sortNo) {
        this.code = code;
        this.description = description;
        this.sortNo = sortNo;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public int getSortNo() {
        return sortNo;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setUdcCode(this.code);
        sysUdcVO.setUdcName(this.description);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public static List<SysUdcVO> getSysUdcVOList() {
        ArrayList<SysUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }

    private static final Map<String, MsgSendTypeEnum> ALL = Arrays.stream(MsgSendTypeEnum.values())
            .collect(Collectors.toMap(MsgSendTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 转换对象
     *
     * @param value
     * @return
     */
    public static MsgSendTypeEnum parse(String value) {
        return ALL.get(value);
    }
}
