package com.elitescloud.cloudt.system.constant;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;

/**
 * 用户类型.
 *
 * @author Kaiser（wang shao）
 * 2022/10/26
 */
public class UserType extends BaseUdc<UserType> {
    private static final long serialVersionUID = -4041360734585374119L;

    public static final UserType ADMIN_SYSTEM = new UserType("admin_system", "系统管理员");
    public static final UserType ADMIN_TENANT = new UserType("admin_tenant", "租户管理员");
    public static final UserType ADMIN_ORG = new UserType("admin_org", "组织管理员");
    public static final UserType EMPLOYEE = new UserType("employee", "员工");
    public static final UserType SALESMAN = new UserType("salesman", "业务员");

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public String getUdcCode() {
        return "userType";
    }

    public UserType() {
    }

    public UserType(String value) {
        super(value);
    }

    public UserType(String value, String description) {
        super(value, description);
    }
}
