package com.elitescloud.cloudt.system.dto.resp;

import com.elitescloud.boot.common.param.TreeRespParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 组织树节点.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "组织树节点")
public class OrgTreeNodeRespVO extends TreeRespParam<OrgTreeNodeRespVO> {
    private static final long serialVersionUID = -3281592467822984459L;

    /**
     * 节点类型
     */
    @ApiModelProperty(value = "节点类型", position = 4)
    private String nodeType;

    /**
     * 节点类型名称
     */
    @ApiModelProperty(value = "节点类型名称", position = 4)
    private String nodeTypeName;

    /**
     * 数据类型
     */
    @ApiModelProperty(value = "数据类型", position = 5)
    private String dataType;

    /**
     * 账号ID
     */
    @ApiModelProperty(value = "账号ID", position = 6)
    private Long userId;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private transient Long tempId;


    @JsonIgnore
    @ApiModelProperty(value = "多语言", position = 7)
    private String langJson;
}
