package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.GroupRoleRespVO;
import com.elitescloud.cloudt.system.dto.resp.RoleGroupPageRespVO;
import com.elitescloud.cloudt.system.param.SysRoleQueryParam;
import com.elitescloud.cloudt.system.provider.dto.SysRoleRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysRoleRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * @author Chris
 * 2021-08-27
 */
@FeignClient(name = Application.NAME, path = SysRoleRpcService.URI)
@Validated
@DocumentedFeignApi( description = "角色服务")
@Deprecated(forRemoval = true)
public interface SysRoleRpcService {
    String URI = Application.URI_PREFIX + "/role";

    /**
     * 获取 应用角色 信息
     *
     * @param param 查询参数
     * @return 应用角色信息
     */
    @PostMapping(value = "/findRoleRpcDtoByParam")
    @DocumentedFeignApi( description = "获取应用角色信息")
    List<SysRoleRpcDTO> findRoleRpcDtoByParam(@RequestBody SysRoleRpcDtoParam param);

    /**
     * @param param
     * @return
     */
    @PostMapping(value = "/search")
    @DocumentedFeignApi( description = "角色查询")
    PagingVO<SysRoleVO> search(@RequestBody SysRoleQueryParam param);

    @PostMapping(value = "/listByRoleIds")
    @DocumentedFeignApi( description = "角色查询，根据多个id")
    Set<SysRoleVO> listByRoleIds(@RequestBody List<Long> roleIds);

    @PostMapping(value = "/listgroup")
    @DocumentedFeignApi( description = "查询角色组")
    PagingVO<RoleGroupPageRespVO> listRoleGroup(@RequestParam(name = "groupName", required = false) String groupName);

    @PostMapping(value = "/listbygroupid")
    @DocumentedFeignApi( description = "角色查询，根据角色组id")
    Set<GroupRoleRespVO> listByGroupId(@RequestParam(name = "groupId") long groupId);

    @GetMapping(value = "/listAll")
    @DocumentedFeignApi( description = "角色查询全部")
    List<SysRoleVO> listAll();

    @GetMapping(value = "/listMenusById")
    @DocumentedFeignApi( description = "废弃不可用")
    List<String> listMenusById(@RequestParam(value = "id") @NotNull(message = "ID不能为空") Long id);

    @GetMapping(value = "/listActionsById")
    @DocumentedFeignApi( description = "废弃不可用")
    List<String> listActionsById(@RequestParam(value = "id") @NotNull(message = "ID不能为空") Long id);

    @GetMapping(value = "/switchRoleStatus")
    @DocumentedFeignApi( description = "角色状态")
    Boolean switchRoleStatus(@RequestParam(value = "id") @NotNull(message = "ID不能为空") Long id);
}
