package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * UDC RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/10/25
 */
@FeignClient(name = Application.NAME, path = SysLanguageRpcService.URI)
@Validated
@DocumentedFeignApi( description = "UDC服务")
public interface SysLanguageRpcService {
    String URI = Application.URI_PREFIX + "/language";

    /**
     * 获取国际化语言包信息
     * @param langCode 应用编码
     * @param appCode 应用编码
     * @param langFeature 语言类型
     * @return 国际化语言包
     */
    @GetMapping(value = "/get")
    @DocumentedFeignApi( description = "获取国际化语言包信息")
    ApiResult<Map<String,String>> getLanguagePackage(@NotBlank(message = "语种编码不能为空") @RequestParam(name = "langCode") String langCode,
                                      @NotBlank(message = "应用编码不能为空") @RequestParam(name = "appCode") String appCode,
                                      @NotBlank(message = "语言类型不能为空") @RequestParam(name = "udcCode") String langFeature);

}
