package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysPlatformAreaDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = SysPlatformDataService.URI)
@Validated
@DocumentedFeignApi( description = "系统域基础数据服务")
public interface SysPlatformDataService {
    String URI = Application.URI_PREFIX + "/basicdata";

    /**
     * 根据查询条件对象，将找到的设置记录分页返回
     *
     * @param code 查询条件对象
     * @return 分页后的设置记录集合
     */
    @PostMapping(value = "/area/bycode")
    @DocumentedFeignApi( description = "根据区域码获取对应区域记录")
    ApiResult<SysPlatformAreaDTO> findOneByCode(@RequestBody String code);
}
