package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.ClockInEmployeeRespDTO;
import com.elitescloud.cloudt.system.dto.resp.ClockInRoleRespDTO;
import com.elitescloud.cloudt.system.dto.resp.ClockInUserOrgRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

@FeignClient(name = Application.NAME, path = SysQueryForClockInRpcService.URI)
@Validated
@DocumentedFeignApi( description = "考勤系统用查询接口")
public interface SysQueryForClockInRpcService {

    String URI = Application.URI_PREFIX + "/sysqueryforclockin";

    @PostMapping(value = "/employeebyrole/{roleId}")
    @DocumentedFeignApi( description = "根据角色ID列出对应员工")
    ApiResult<List<ClockInEmployeeRespDTO>> listEmployeesByRoleId(@PathVariable Long roleId);

    @PostMapping(value = "/rolebyemployee")
    @DocumentedFeignApi( description = "根据用户ID列出对应角色")
    ApiResult<Map<Long, List<ClockInRoleRespDTO>>> listRolesByEmployeeId(@RequestBody List<Long> employeeIds);

    @PostMapping(value = "/orgbyemployee")
    @DocumentedFeignApi( description = "根据用户ID列出对应组织信息")
    ApiResult<Map<Long, List<ClockInUserOrgRespDTO>>> listOrgByEmployee(@RequestBody List<Long> employeeIds);
}
