package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.boot.model.dto.SysBusinessObjectDTO;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@FeignClient(name = Application.NAME, path = SysBusinessObjectRpcService.URI)
@Validated
@DocumentedFeignApi(description = "业务对象服务")
public interface SysBusinessObjectRpcService {

    String URI = Application.URI_PREFIX + "/businessObject";

    /**
     * 获取所有的业务对象信息
     *
     * @return
     */
    @GetMapping(value = "/businessObject/all")
    ApiResult<List<SysBusinessObjectDTO>> allBusinessObject();

    /**
     * 获取业务对象详细信息
     *
     * @param businessObjectCode 业务对象编码
     * @return
     */
    @GetMapping(value = "/businessObject/detail")
    ApiResult<SysBusinessObjectDTO> getBusinessObjectDetail(@RequestParam(name = "businessObjectCode") @NotBlank(message = "业务对象编码为空") String businessObjectCode);

    /**
     * 获取所有的业务操作
     *
     * @return 业务操作列表
     */
    @GetMapping(value = "/operation/all")
    ApiResult<List<SysBusinessOperationDTO>> allOperation();
}
