package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysMqConsumeResultDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqMessageStorageDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqSendResultDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * MQ消息的RPC服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
@FeignClient(name = Application.NAME, path = SysMqMessageRpcService.URI)
@Validated
@DocumentedFeignApi( description = "MQ消息服务")
public interface SysMqMessageRpcService {
    String URI = Application.URI_PREFIX + "/mq";

    /**
     * 保存消息
     *
     * @param messageDTO 消息信息
     * @return 消息ID
     */
    @PostMapping(value = "/saveMessage")
    ApiResult<String> saveMessage(@RequestBody @Valid SysMqMessageStorageDTO messageDTO);

    /**
     * 更新消息结果
     *
     * @param sendResult 发送结果
     * @return 消息ID
     */
    @PutMapping(value = "/updateResult")
    ApiResult<String> updateSendResult(@RequestBody @Valid SysMqSendResultDTO sendResult);

    /**
     * 更新消息发送结果
     *
     * @param consumeResult 消费结果
     * @return 消息ID
     */
    @PostMapping(value = "/updateConsumeResult")
    ApiResult<String> updateConsumeResult(@RequestBody @Valid SysMqConsumeResultDTO consumeResult);
}
