package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 行政区域.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheAreaRpcService extends CacheableService {

    /**
     * 根据行政区域编码获取
     *
     * @param areaCode 行政区域编码
     * @return 行政区域编码
     */
    SysAreaRespDTO getByCode(@NotBlank String areaCode);

    /**
     * 获取行政区域列表
     *
     * @return 所有行政区域列表
     */
    List<SysAreaRespDTO> getAll();
}
