package com.elitescloud.cloudt.system.provider.dto.save;

import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 菜单保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/16
 */
@Getter
@Setter
public class SysMenuSaveDTO implements Serializable {
    private static final long serialVersionUID = -6851707910075214099L;

    /**
     * 菜单归属应用
     */
    @NotBlank(message = "应用编码为空")
    private String menusAppCode;

    /**
     * 菜单名称
     */
    @NotBlank(message = "菜单名称为空")
    private String menusName;

    /**
     * 菜单类型
     */
    private PlatformAppMenusTypeEnum menusTypeEnum;

    /**
     * 菜单编码
     */
    @NotBlank(message = "菜单编码为空")
    private String menusCode;

    /**
     * 上级菜单编码
     */
    private String menusParentCode;

    /**
     * 菜单节点类型
     */
    private PlatformMenusNodeEnum nodeTypeEnum;

    /**
     * 菜单路由
     */
    private String menusRoute;

    /**
     * 图标
     */
    private String menusIcon;

    /**
     * 是否外链接
     */
    private Boolean outerLink;

    /**
     * 外链接类型
     */
    private PlatformMenusOuterLinkTypeEnum outerLinkTypeEnum;
}
