package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheAppRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.provider.SysAppRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "应用")
public class SysCacheAppRpcServiceImpl extends AbstractCacheableService implements SysCacheAppRpcService {

    @CloudtCacheMethod(name = "根据应用编码获取应用信息")
    @Override
    public CodeNameParam getByCode(String code) {
        Assert.hasText(code, "应用编码为空");

        var appList = getRpcService().allApp().computeData();
        if (CollUtil.isEmpty(appList)) {
            return null;
        }
        for (CodeNameParam codeNameParam : appList) {
            if (code.equals(codeNameParam.getCode())) {
                return codeNameParam;
            }
        }
        return null;
    }

    @CloudtCacheMethod(name = "获取应用列表")
    @Override
    public List<CodeNameParam> getAll() {
        return getRpcService().allApp().computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "app";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }

    private SysAppRpcService getRpcService() {
        return SpringContextHolder.getBean(SysAppRpcService.class);
    }
}
