package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheAreaRpcService;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheAreaRpcServiceImpl extends AbstractCacheableService implements SysCacheAreaRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "area";
    }

    @Override
    public SysAreaRespDTO getByCode(String areaCode) {
        Assert.hasText(areaCode, "行政区域编码为空");
        return super.getOne(areaCode, () -> getService(SysAreaRpcService.class).getByAreaCode(areaCode).computeData());
    }

    @Override
    public List<SysAreaRespDTO> getAll() {
        return super.getAll(() -> getService(SysAreaRpcService.class).queryAll(false).computeData());
    }
}
