package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheCurrencyRpcService;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheCurrencyRpcServiceImpl extends AbstractCacheableService implements SysCacheCurrencyRpcService {

    @Override
    public SysCurrencyRespDTO getByCode(String currencyCode) {
        Assert.hasText(currencyCode, "货币编码为空");
        return super.getOne(currencyCode, () -> getService(SysCurrencyRpcService.class).getByCode(currencyCode).computeData());
    }

    @Override
    public List<SysCurrencyRespDTO> currencyList() {
        return super.getAll(() -> getService(SysCurrencyRpcService.class).queryList(new SysCurrencyQueryDTO()).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "currency";
    }
}
