package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeGroupRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeGroupRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheEmployeeGroupRpcServiceImpl extends AbstractCacheableService implements SysCacheEmployeeGroupRpcService {

    @Override
    public SysEmpGroupDTO getByCode(String groupCode) {
        Assert.hasText(groupCode, "员工组编码为空");

        return super.getOne("groupCode_#_" + groupCode, () -> getService(EmployeeGroupRpcService.class).getByCode(groupCode).computeData());
    }

    @Override
    public SysEmpGroupDTO getById(Long groupId) {
        Assert.notNull(groupId, "员工组ID为空");

        return super.getOne("groupId_#_" + groupId, () -> getService(EmployeeGroupRpcService.class).getById(groupId).computeData());
    }

    @Override
    public List<SysEmpGroupDTO> listAll() {
        return super.getAll(() -> getService(EmployeeGroupRpcService.class).listAll().computeData());
    }

    @Override
    public List<Long> listUserIdByGroupCode(String groupCode) {
        Assert.hasText(groupCode, "员工组编码为空");

        return super.getOne("groupUserId_#_" + groupCode, () -> getService(EmployeeGroupRpcService.class).getUserIdsByGroupCode(groupCode).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "employeeGroup";
    }
}
