package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeRpcService;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheEmployeeRpcServiceImpl extends AbstractCacheableService implements SysCacheEmployeeRpcService {

    @Override
    public SysEmployeeBasicDTO getById(Long id) {
        Assert.notNull(id, "员工ID为空");

        return super.getOne("id_#_" + id, () -> getRpcService().getById(id).computeData());
    }

    @Override
    public SysEmployeeBasicDTO getByCode(String code) {
        Assert.notBlank(code, "员工编码为空");

        return super.getOne("code_#_" + code, () -> getRpcService().getByCode(code).computeData());
    }

    @Override
    public SysEmployeeBasicDTO getByUserId(Long userId) {
        Assert.notNull(userId, "账号ID为空");

        return super.getOne("userId_#_" + userId, () -> getRpcService().getByUserId(userId).computeData());
    }

    @Override
    public SysEmployeeBasicDTO getByUsername(String username) {
        Assert.notBlank(username, "员工账号为空");

        return super.getOne("username_#_" + username, () -> getRpcService().getByUsername(username).computeData());
    }

    @Override
    public List<SysEmployeeBasicDTO> listAll() {
        return super.getAll(() -> getRpcService().queryList(new EmployeeQueryDTO()).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "employee";
    }

    private EmployeeRpcService getRpcService() {
        return getService(EmployeeRpcService.class);
    }
}
