package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheOrgRpcService;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheOrgRpcServiceImpl extends AbstractCacheableService implements SysCacheOrgRpcService {

    @Override
    public SysOrgBasicDTO get(Long orgId) {
        Assert.notNull(orgId, "组织ID为空");
        return super.getOne("id_#_" + orgId, () -> getRpcService().getById(orgId).computeData());
    }

    @Override
    public SysOrgBasicDTO getByCode(String orgCode) {
        Assert.notBlank(orgCode, "组织编码为空");
        return super.getOne("code_#_" + orgCode, () -> getRpcService().getByCode(orgCode).computeData());
    }

    @Override
    public List<SysOrgBasicDTO> listAll() {
        return super.getAll(() -> getRpcService().queryList(new SysOrgQueryDTO()).computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "org";
    }

    private OrgRpcService getRpcService() {
        return getService(OrgRpcService.class);
    }
}
