package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheTenantRpcService;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.provider.TenantRpcProvider;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
public class SysCacheTenantRpcServiceImpl extends AbstractCacheableService implements SysCacheTenantRpcService {

    @Override
    public SysTenantDTO getByCode(String code) {
        Assert.hasText(code, "租户编码为空");
        return super.getOne("code", () -> getRpcService().getByCode(code).computeData());
    }

    @Override
    public List<SysTenantDTO> getAll() {
        return super.getAll(() -> getRpcService().allTenants().computeData());
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "tenant";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }

    private TenantRpcProvider getRpcService() {
        return getService(TenantRpcProvider.class);
    }
}
