package com.elitescloud.cloudt.system.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息发送类型的具体发送参数枚举
 * **/
public enum MsgSendTypeParamEnum {
    EMAIL_ADDRESS("SYS", "MsgSendTypeParam", "EMAIL_ADDRESS", "邮箱地址",1),
    MOBILE_PHONE_NUMBER("SYS", "MsgSendTypeParam", "MOBILE_PHONE_NUMBER", "手机号",2),
    EXTERNAL_SYSTEM_TEMPLATE_ID("SYS", "MsgSendTypeParam", "EXTERNAL_SYSTEM_TEMPLATE_ID", "外部系统模板ID",3),
    ;


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

//    private final String udcParentCode;
    MsgSendTypeParamEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
//        this.udcParentCode=udcParentCode;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public static List<SysUdcVO> getSysUdcVOList() {
        ArrayList<SysUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
