package com.elitescloud.cloudt.system.dto;

import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2/28/2023
 */
@Data
public class SysEmployeeDetailDTO implements Serializable {
    private static final long serialVersionUID = 2588133678930173478L;

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 用户账号ID
     */
    private Long userId;

    /**
     * 员工编号
     */
    private String code;

    /**
     * 员工类型
     */
    private String type;
    private String typeName;

    /**
     * 职务
     */
    private String duty;

    /**
     * 照片编码
     */
    private String photo;

    /**
     * 入职时间
     */
    private LocalDateTime joinTime;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 是否启用
     */
    private Boolean enabled;


    // 账号信息

    /**
     * 用户账号
     */
    private String username;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * {@link com.elitescloud.boot.constant.Gender}
     */
    private String gender;
    private String genderName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 办公电话、手机号
     */
    private String phone;

    /**
     * 生日
     */
    private LocalDate birthDate;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 所在地
     */
    private AreaVO areaVO;

    /**
     * 地址
     */
    private String address;

    /**
     * 组织信息
     */
    private List<EmployeeOrg> orgList;

    /**
     * 角色信息
     */
    private List<IdCodeNameParam> roleList;

    /**
     * 是否没有登录账号
     */
    private Boolean withoutLoginAccount;

    @Data
    public static class EmployeeOrg implements Serializable {
        private static final long serialVersionUID = -7057452386964797575L;

        /**
         * 员工ID
         */
        private Long employeeId;

        /**
         * 组织ID
         */
        private Long orgId;

        /**
         * 组织编号
         */
        private String orgCode;

        /**
         * 组织名称
         */
        private String orgName;

        /**
         * 组织类型
         */
        private String orgType;

        /**
         * 领导的员工编号
         */
        private String leaderEmployeeCode;

        /**
         * 领导的员工ID
         */
        private Long leaderEmployeeId;

        /**
         * 上级领导ID
         */
        private Long leaderUserId;

        /**
         * 上级领导姓名
         */
        private String leaderUserFullName;

        /**
         * 组织列表
         */
        private List<SysOrgBasicDTO> orgList;

        /**
         * 岗位信息
         */
        private IdCodeNameParam position;
    }
}
