package com.elitescloud.cloudt.system.dto.req;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 统一查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/6
 */
@Getter
@Setter
public class UnifyQueryQueryDTO implements Serializable {
    private static final long serialVersionUID = 7048872921047927943L;

    /**
     * 查询业务对象编码
     */
    @NotBlank(message = "查询业务对象编码不能为空")
    private String businessObjectCode;

    /**
     * 查询字段
     */
    @NotEmpty(message = "查询字段不能为空")
    private List<String> queryFields;

    /**
     * 查询条件
     */
    private Map<String, Object> conditions;
}
