package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.constant.CacheKey;
import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysApiPermissionMetadataDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * Api权限接口.
 *
 * @author Kaiser（wang shao）
 * 2022/11/7
 */
@FeignClient(name = Application.NAME, path = SysApiPermissionRpcService.URI)
@Validated
@DocumentedFeignApi( description = "Api权限服務")
public interface SysApiPermissionRpcService {
    String URI = Application.URI_PREFIX + "/api_permission";

    /**
     * 查询应用的权限数据
     *
     * @param appCode    应用编码
     * @param tenantCode 租户编码
     * @return 权限列表
     */
    @GetMapping(value = "/permission/metadata")
    @DocumentedFeignApi( description = "查询应用的权限数据")
    ApiResult<List<SysApiPermissionMetadataDTO>> queryPermissionMetadata(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                                                         @RequestParam(name = "tenantCode") String tenantCode);

    /**
     * 应用的权限数据缓存Key
     *
     * @return 缓存Key
     */
    static String cacheKeyForPermissionMetadata() {
        return CacheKey.CACHE_API_METADATA;
    }

    /**
     * 应用的权限数据缓存item
     *
     * @param appCode    应用编码
     * @param tenantCode 租户编码
     * @return 缓存item
     */
    static String cacheItemForPermissionMetadata(String appCode, String tenantCode) {
        return appCode + "::" + tenantCode;
    }
}
