package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.req.ThirdApiLogQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 三方接口调用日志.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
@FeignClient(name = Application.NAME, path = SysThirdApiLogRpcService.URI)
@Validated
@DocumentedFeignApi( description = "三方接口调用日志")
public interface SysThirdApiLogRpcService {
    String URI = Application.URI_PREFIX + "/thirdApiLog";

    /**
     * 保存日志
     *
     * @param logDTO 日志信息
     * @return 日志ID
     */
    @PostMapping(value = "/save")
    @DocumentedFeignApi( description = "保存日志")
    ApiResult<Long> saveLog(@RequestBody @Valid ThirdApiLogDTO logDTO);

    /**
     * 分页查询日志
     *
     * @param requestDTO 查询参数
     * @return 日志列表
     */
    @PostMapping(value = "/queryByPage")
    @DocumentedFeignApi( description = "分页查询日志")
    ApiResult<PagingVO<ThirdApiLogDTO>> queryByPage(@RequestBody ThirdApiLogQueryDTO requestDTO);
}
