package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.*;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * @author Chris
 * 2021-08-27
 * @deprecated 请使用 {@link com.elitescloud.cloudt.system.provider.org.UserRpcService}
 */
@FeignClient(name = Application.NAME, path = SysUserRpcService.URI)
@Validated
@Deprecated(forRemoval = true, since = "3.2.0")
@DocumentedFeignApi( description = "USER服务")
public interface SysUserRpcService {
    String URI = Application.URI_PREFIX + "/user";

    /**
     * 根据查询条件检索用户信息
     *
     * @param param 查询条件对象
     * @return 用户信息集合
     */
    @PostMapping(value = "/search")
    @DocumentedFeignApi( description = "根据查询条件检索用户信息")
    PagingVO<SysUserVO> search(@RequestBody SysUserQueryParam param);

    /**
     * @param id
     * @return
     */
    @GetMapping(value = "/getById")
    @DocumentedFeignApi( description = "查询用户信息")
    SysUserDTO getById(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id);

    @PostMapping(value = "/getByIds")
    @DocumentedFeignApi( description = "批量查询用户信息")
    List<SysUserVO> getByIds(@RequestBody List<Long> ids);

    /**
     * 创建新用户
     *
     * @param user 用户账号信息
     * @return 新用户账号ID
     */
    @PostMapping(value = "/create")
    @DocumentedFeignApi( description = "创建新用户")
    Long create(@RequestBody SysUserNewParam user);

    @PostMapping(value = "/createWithPwd")
    @DocumentedFeignApi( description = "创建新用户，带密码")
    Long create(@RequestBody SysUserNewParam user,
                @RequestParam(value = "password") @NotNull(message = "用户密码为空") String password);

    @PostMapping(value = "/update")
    @DocumentedFeignApi( description = "更新用户")
    void update(@RequestBody SysUserUpdateParam user);

    @GetMapping(value = "/switchUserStatus")
    @DocumentedFeignApi( description = "查找用户")
    Boolean switchUserStatus(@RequestParam(value = "id") @NotNull(message = "用户ID为空") Long id);

    /**
     * 用户 批量启用/禁用
     *
     * @param param 参数
     */
    @PostMapping(value = "/batchSwitchUserStatus")
    @DocumentedFeignApi( description = "用户 批量启用/禁用")
    void batchSwitchUserStatus(@RequestBody SysUserBatchSwitchParam param);

    @GetMapping(value = "/listRolesByUsername")
    @DocumentedFeignApi( description = "查询用户角色")
    Set<SysRoleVO> listRolesByUsername(@RequestParam(value = "username") @NotNull(message = "用户账号为空") String username);

    @GetMapping(value = "/current")
    @DocumentedFeignApi( description = "获取当前登录用户")
    SysUserDTO current();

    @GetMapping(value = "/currentMenu")
    @DocumentedFeignApi( description = "获取当前登录用户权限菜单")
    List<SysPermissionVO> currentMenu();

    @GetMapping(value = "/currentActions")
    @DocumentedFeignApi( description = "获取当前登录用户权限按钮")
    Set<SysPermissionVO> currentActions();

    @GetMapping(value = "/currentMenuActions")
    @DocumentedFeignApi( description = "获取当前登录用户权限菜单下按钮")
    Set<SysPermissionVO> currentMenuActions(@RequestParam(value = "menuId") @NotNull(message = "菜单ID为空") Long menuId);

    @DeleteMapping(value = "/deleteBatch")
    @DocumentedFeignApi( description = "批量删除用户")
    void deleteBatch(@RequestBody List<Long> idList);

    @PostMapping(value = "/updatePassword")
    @DocumentedFeignApi( description = "更新密码")
    void updatePassword(@RequestBody SysPasswordUpdate update);

    @PutMapping(value = "/updatePassword")
    @DocumentedFeignApi( description = "更新密码")
    void changePasswordNoSec(@RequestParam(value = "userId") @NotNull(message = "用户ID为空") Long userId,
                             @RequestParam(value = "pwd", required = false)  String pwd);

    /**
     * 更新用户绑定的微信id
     *
     * @param userName 用户登录号
     * @param openid   微信id
     * @return 用户登录号
     */
    @GetMapping(value = "/updateUserWechatOpenid")
    @DocumentedFeignApi( description = "更新用户绑定的微信id")
    ApiResult<String> updateUserWechatOpenid(@RequestParam(value = "userName") @NotBlank(message = "登录号不能为空") String userName,
                                             @RequestParam(value = "openid", required = false) String openid);

    /**
     * 查询用户信息
     *
     * @param param 查询条件
     * @return dto
     */
    @PostMapping(value = "/findUserRpcDtoByParam")
    @DocumentedFeignApi( description = "查询用户信息")
    List<SysUserRpcDTO> findUserRpcDtoByParam(@RequestBody SysUserRpcDtoParam param);

    /**
     * 第三方，创建用户账号，创建的默认来源为 oth
     *
     * @param param 保存参数
     * @return 用户id
     */
    @PostMapping(value = "/sysUserAccountCreate")
    @DocumentedFeignApi( description = "第三方，创建用户账号，创建的默认来源为 oth")
    ApiResult<Object> sysUserAccountCreate(@RequestBody SysUserRpcSaveParam param);

    @PostMapping(value = "/sysUserCreate")
    @DocumentedFeignApi( description = "用户创建接口")
    ApiResult<Long>  sysUserCreate(@RequestBody SysUserNewParam user,
                                   @RequestParam(name = "password") @NotBlank(message = "密码为空") String password);

    /**
     * 根据用户名获取用户ID
     *
     * @param username 用户名
     * @return 用户ID
     */
    @GetMapping(value = "/getUserIdByUsername")
    @DocumentedFeignApi( description = "根据用户名获取用户ID")
    ApiResult<Long> getUserIdByUsername(@RequestParam(name = "username") @NotBlank(message = "用户名为空") String username);

    /**
     * 根据用户账号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param username 用户账号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByUsername")
    @DocumentedFeignApi( description = "根据用户账号查询用户详细信息")
    ApiResult<SysUserDTO> getUserByUsername(@RequestParam(name = "username") @NotBlank(message = "用户名为空") String username);

    /**
     * 根据用户手机号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param mobile 手机号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByMobile")
    @DocumentedFeignApi( description = "根据用户手机号查询用户详细信息")
    ApiResult<SysUserDTO> getUserByMobile(@RequestParam(name = "mobile") @NotBlank(message = "手机号为空") String mobile);

    /**
     * 根据用户邮箱查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param email 邮箱
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByEmail")
    @DocumentedFeignApi( description = "根据用户邮箱查询用户详细信息")
    ApiResult<SysUserDTO> getUserByEmail(@RequestParam(name = "email") @NotBlank(message = "邮箱为空") String email);

    /**
     * 根据用户ID查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param userId 用户ID
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserById")
    @DocumentedFeignApi( description = "根据用户ID查询用户详细信息")
    ApiResult<SysUserDTO> getUserById(@RequestParam(name = "userId") @NotBlank(message = "用户ID为空") String userId);

    /**
     * 根据用户微信号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param wechatOpenid 用户微信号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByWechatOpenid")
    @DocumentedFeignApi( description = "根据用户微信号查询用户详细信息")
    ApiResult<SysUserDTO> getUserByWechatOpenid(@RequestParam(name = "wechatOpenid") @NotBlank(message = "微信号为空") String wechatOpenid);

    /**
     * 账号为空
     *
     * @param account 账号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByAccount")
    @DocumentedFeignApi( description = "账号为空")
    ApiResult<SysUserDTO> getUserByAccount(@RequestParam(name = "account") @NotBlank(message = "账号为空") String account);

    @GetMapping(value = "/existsByUserName")
    @DocumentedFeignApi( description = "用户名是存在")
    Boolean existsByUserName(@RequestParam(name = "userName") @NotBlank(message = "用户名为空") String userName);

    @GetMapping(value = "/existsByUserMobile")
    @DocumentedFeignApi( description = "手机号是存在")
    Boolean existsByUserMobile(@RequestParam(name = "mobile") @NotBlank(message = "手机号为空") String mobile);
}
