package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 租户RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@FeignClient(name = Application.NAME, path = TenantRpcProvider.URI)
@Validated
@DocumentedFeignApi( description = "租户服务")
public interface TenantRpcProvider {
    String URI = Application.URI_PREFIX + "/tenant";

    /**
     * 查询所有租户信息
     *
     * @return 租户信息
     */
    @GetMapping(value = "/allTenants")
    @DocumentedFeignApi( description = "查询所有租户信息")
    ApiResult<List<SysTenantDTO>> allTenants();

    /**
     * 根据租户编码获取
     *
     * @param code
     * @return
     */
    @GetMapping(value = "/getByCode")
    @DocumentedFeignApi( description = "根据租户编码获取")
    ApiResult<SysTenantDTO> getByCode(@NotBlank(message = "租户编码为空") @RequestParam(name = "code") String code);
}
