package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@FeignClient(name = Application.NAME, path = SysThirdPartyAccountRpcService.URI)
@Validated
@DocumentedFeignApi( description = "第三方账号服务")
public interface SysThirdPartyAccountRpcService {
    String URI = Application.URI_PREFIX + "/third_party";

    /**
     * 根据应用账号查询租户ID
     *
     * @param account 应用账号，如微信的AppID
     * @return 租户ID
     */
    @GetMapping(value = "/getTenantIdByAccount")
    @DocumentedFeignApi( description = "根据小程序或APP或公众号账号配置，找到账号对应租户配置")
    ApiResult<Long> getTenantIdByAccount(@NotBlank(message = "应用账号为空") @RequestParam(name = "account") String account);
}
