package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 员工组服务.
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@FeignClient(name = Application.NAME, path = EmployeeGroupRpcService.URI)
@Validated
@DocumentedFeignApi( description = "员工组服务")
public interface EmployeeGroupRpcService {
    String URI = Application.URI_PREFIX + "/emp_group";

    /**
     * 根据员工组编码获取组信息
     *
     * @param groupCode
     * @return
     */
    @GetMapping(value = "/getByCode")
    ApiResult<SysEmpGroupDTO> getByCode(@NotBlank(message = "分组编码为空") @RequestParam(value = "groupCode") String groupCode);

    /**
     * 根据员工组ID获取组信息
     *
     * @param groupId
     * @return
     */
    @GetMapping(value = "/getById")
    ApiResult<SysEmpGroupDTO> getById(@NotNull(message = "分组ID为空") @RequestParam(value = "groupId") Long groupId);

    /**
     * 获取员工组列表
     *
     * @return
     */
    @GetMapping(value = "/list")
    ApiResult<List<SysEmpGroupDTO>> listAll();

    /**
     * 根据员工组查询用户ID
     * <p>
     * 查询员工组下的员工的用户ID
     *
     * @param groupCode 员工组编号
     * @return 用户ID列表
     */
    @GetMapping(value = "/getUserIdsByGroupCode")
    ApiResult<List<Long>> getUserIdsByGroupCode(@NotBlank(message = "员工组编号为空") @RequestParam(value = "groupCode") String groupCode);

    /**
     * 根据员工组编号查询用户ID
     *
     * @param groupCodes 员工组编号
     * @return 员工组件与用户ID的map
     */
    @PostMapping(value = "/queryUserIdsByGroupCodes")
    ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(@NotEmpty(message = "员工组编码为空") @RequestBody Set<String> groupCodes);
}
