package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.BuTreeNodeQueryEmployeeDTO;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmpOrgTreeOrgDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePagedRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgDetailRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 组织树服务接口.
 *
 * @author nc
 * @date 6/5/2023
 */
@FeignClient(name = Application.NAME, path = OrgTreeRpcService.URI)
@Validated
@DocumentedFeignApi( description = "组织树服务")
public interface OrgTreeRpcService {
    String URI = Application.URI_PREFIX + "/orgTree";


    /**
     * 根据组织树和组织查询用户信息
     */
    @PostMapping("/buTreeNodeQueryEmployee")
    @DocumentedFeignApi( description = "根据组织树和组织查询用户信息")
    ApiResult<List<EmployeePagedRespDTO>> buTreeNodeQueryEmployee(@RequestBody  @Valid BuTreeNodeQueryEmployeeDTO param) ;


    /**
     * 根据组织树和员工 查询下级组织
     */
    @PostMapping("/searchOrgByOrgTreeCodeAndEmpId")
    @ApiOperation("根据组织树编码和员工编码查询本机和下级组织")
    @DocumentedFeignApi( description = "根据组织树编码和员工编码查询本机和下级组织")
     ApiResult<List<EmpOrgTreeOrgDTO>> searchByOrgTreeCodeAndEmpId(@RequestBody  @Valid SearchByOrgTreeCodeAndEmpIdParam param);


}
