package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysSendResultParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * @author : chen.niu
 * @description : 模板消息服务消息发送接口
 * @date : 2023/5/25 11:01
 */
@FeignClient(name = Application.NAME, path = SysMsgTemplateSendRpcService.URI)
@Validated
@DocumentedFeignApi( description = "模板消息服务")
public interface SysMsgTemplateSendRpcService {
    String URI = Application.URI_PREFIX + "/msg/template/send";

    /**
     * 模板消息批量，员工参数发送接口（RPC接口
     * EmployeeSendParamDTO 模板消息员工对象
     *
     * @return 批记录ID
     */
    @PostMapping(value = "/templateEmployeeSend")
    @DocumentedFeignApi( description = "模板消息批量，员工参数发送接口")
    ApiResult<String> msgTemplateEmployeeSend(@RequestBody @Valid TemplateEmployeeSendParamDTO param);

    /**
     * 模板消息批量，员工参数发送接口（RPC接口
     * EmployeeSendParamDTO 模板消息员工对象
     *
     * @return 成功失败
     */
    @PostMapping(value = "/templateEmployeeSend/batch")
    @DocumentedFeignApi( description = "模板消息批量，员工参数发送接口（RPC接口")
    ApiResult<List<SysSendResultParam>> msgTemplateEmployeeSend(@RequestBody @Valid List<TemplateEmployeeSendParamDTO> paramList);

    /**
     * 模板消息，传递发送自定义参数接口（RPC接口）
     *
     * @return 批记录ID
     */
    @PostMapping(value = "/templateMsgTypeParamSend")
    @DocumentedFeignApi( description = "模板消息，传递发送自定义参数接口")
    ApiResult<String> msgTemplateMsgTypeParamSend(@RequestBody @Valid TemplateAssignSendParamDTO param);

    /**
     * 模板消息批量，传递发送参自定义数接口（RPC接口）
     *
     * @return 成功失败
     */
    @PostMapping(value = "/templateMsgTypeParamSend/batch")
    @DocumentedFeignApi( description = "模板消息批量，传递发送参自定义数接口")
    ApiResult<List<SysSendResultParam>> msgTemplateMsgTypeParamSend(@RequestBody @Valid List<TemplateAssignSendParamDTO> paramList);

    /**
     * 模板消息，接收人发送 RPC接口
     * EmployeeSendParamDTO 模板消息员工对象
     *
     * @return 批记录ID
     */
    @PostMapping(value = "/templateSend")
    @DocumentedFeignApi( description = "模板消息，接收人发送 RPC接口")
    ApiResult<String> msgTemplateSend(@RequestBody @Valid TemplateEmployeeSendParamDTO param);

    /**
     * 查询发送结果
     *
     * @param recordId 批记录ID，同消息记录的batch_uuid
     * @return 记录ID
     */
    @GetMapping(value = "/record/sentResult")
    @DocumentedFeignApi( description = "查询发送结果")
    ApiResult<SysMsgSentResultDTO> getSentResult(@RequestParam(name = "recordId") @NotBlank(message = "发送记录标识为空") String recordId);

    /**
     * 查询发送结果
     *
     * @param recordIds 批记录ID，同消息记录的batch_uuid
     * @return 记录ID
     */
    @PostMapping(value = "/record/sentResult/batch")
    @DocumentedFeignApi( description = "查询发送结果")
    ApiResult<List<SysMsgSentResultDTO>> listSentResult(@RequestBody Set<String> recordIds);

    /**
     * 重试发送
     *
     * @param recordId 批记录ID，同消息记录的batch_uuid
     * @return 记录ID
     */
    @PutMapping(value = "/record/retry")
    @DocumentedFeignApi( description = "重试发送")
    ApiResult<String> retrySend(@RequestParam(name = "recordId") @NotBlank(message = "发送记录标识为空") String recordId);
}
