package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.msg.interior.InteriorReadUpdateDTO;
import com.elitescloud.cloudt.system.dto.req.msg.interior.SysMsgSendRecordDtlQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysMsgSendRecordDtlDTO;
import com.elitescloud.cloudt.system.param.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * @author : chen.niu
 * @description : 站内消息
 * @date : 2023/5/25 15:58
 */
@FeignClient(name = Application.NAME, path = SysMsgWxBootRpcService.URI)
@Validated
@DocumentedFeignApi( description = "站内消息服务")
public interface SysMsgWxBootRpcService {
    String URI = Application.URI_PREFIX + "/msg/wxboot";

    /**
     * 微信BOOT模板批量发送
     *
     * @return 角色ID的数据集合
     */
    @PostMapping(value = "/sysmsgSend")
    ApiResult<PagingVO<SysMsgSendRecordDtlDTO>> sysMsgSendRecordDtlInteriorQuery(@RequestBody @Valid SysMsgSendRecordDtlQueryDTO dto);

}
