package com.elitescloud.cloudt.comm.consumer.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * 2021-06-05
 */
@Data
public class ComPaymentTermRpcDTO implements Serializable {

    private static final long serialVersionUID = -4497178773911358399L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("代码")
    private String ptCode;

    @ApiModelProperty("名称")
    private String ptName;

    @ApiModelProperty("天数")
    private Integer days;

    @ApiModelProperty("基于日期类型")
    private String baseDayType;

    @ApiModelProperty("日期计算方式 是否含工作日")
    private String dayCalcMethod;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("是否有效")
    private Integer enableFlag;
}
