package com.elitescloud.cloudt.constant;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;
import java.io.Serial;

/**
 * 银行类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/1
 */
public class SysBankType extends BaseUdc<SysBankType> {
    @Serial
    private static final long serialVersionUID = 7137869039042888344L;
    public static final String UDC_CODE = "sysBank";

    public static final SysBankType BANK = new SysBankType("BANK", "银行");
    public static final SysBankType BANK_BRANCH = new SysBankType("BANK_BRANCH", "支行");

    public SysBankType() {
    }

    public SysBankType(String value) {
        super(value);
    }

    public SysBankType(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public String getUdcCode() {
        return UDC_CODE;
    }
}
